<?php

use Twinkl\Core\Consts\{DbConsts, EnvConsts};
use Twinkl\Core\Glob\GlobalsGlob;
use Twinkl\Core\Db\Config\DbConfig;
use Twinkl\Eloquent\Util\EloquentUtils;

defined('__DIR__PUBLIC__') or define('__DIR__PUBLIC__', dirname(__DIR__, 3) . '/Sites/public');
defined('__DIR__BE__') or define('__DIR__BE__', dirname(__DIR__, 3) . "/Sites/backend");

require_once __DIR__BE__ . '/vendor/autoload.php';
require_once __DIR__BE__ . '/hooks/error_handler.php';

//slight issue, application bootstrapped to run within docker container
//require_once __DIR__BE__ . '/config/config.php';

//here for the unit tests we are running outside currently
(new GlobalsGlob())
    ->buildEnvByMode(
        getenv(EnvConsts::KEY_TWKL_ENV_MODE) ?: EnvConsts::LOG_LVL_DEBUG
    )
    ->setDbConfigs([
                       'default' => (new DbConfig())
                           ->setDriver(DbConsts::DRIVER_MYSQL)
                           ->setHost('127.0.0.1')
                           ->setDatabase(DbConsts::DB_DEV)
                           ->setUsername(DbConsts::USERNAME_DEV)
                           ->setPassword(DbConsts::KEY_TWKL_DB_PWD)
                   ]);

EloquentUtils::getInstance()->initConnections();

require_once __DIR__BE__ . '/config/session.php';