<?php

class HomeCest
{
    public function _before(AcceptanceTester $I)
    {
    }

    // tests
    public function DisplayUsers(AcceptanceTester $I)
    {
        $I->amOnPage('/');

        //lets first of all define what a fail would look like
        $I->dontsee('Twinkl\Core\Exception\ExceptionExt');

        //lets double check the first record display correctly
        $I->seeInField( 'input[name="firstname"]', 'jane');
        $I->seeInField('input[name="lastname"]', 'doe');
        $I->see('Add User');

        //lights out lets go racing
        $I->expect('The homepage is working as expected');
    }

    /**
     * @param AcceptanceTester $I
     * @param \Codeception\Scenario $scenario
     * @throws Exception
     *
     *
     *
     * @incomplete
     * remove the above flag once you are ready to test your solution
     */
    public function AddUser(AcceptanceTester $I, \Codeception\Scenario $scenario)
    {
        $I->amOnPage('/');
        $I->see('Add User');

        //lets see how many records there are in the database currently
        $user_count = $I->grabFromDatabase('user', 'COUNT(*)');

        $I->click('.add-btn');
        $I->wait(4);

        $I->waitForElement('.dash-user-create');

        $I->fillfield('div.dash-user-create  input[name="firstname"]', 'Paul');
        $I->fillfield('div.dash-user-create  input[name="lastname"]', 'Yiend');
        $I->click('div.dash-user-create .create-btn');

        $latest_id = $user_count++;

        $I->waitForElement("div[data-user-id=\"$latest_id\"]");

        //refresh the page to double check everything did save
        $I->amOnPage('/');

        $I->seeInField( 'input[name="firstname"]', 'Paul');
        $I->seeInField( 'input[name="lastname"]', 'Yiend');

        //elvis has left the building
    }

    /**
     * @param AcceptanceTester $I
     * @param \Codeception\Scenario $scenario
     *
     * @incomplete
     * remove the above flag once you are ready to test your solution
     */
    public function UpdateUser(AcceptanceTester $I, \Codeception\Scenario $scenario)
    {
        $I->amOnPage('/');

        $I->fillField('div.dash-user-edit:first-of-type input[name="firstname"]', 'Rosa');
        $I->fillField('div.dash-user-edit:first-of-type input[name="lastname"]', 'Parks');
        $I->click('div.dash-user-edit:first-of-type .update-btn');

        $I->wait(2);

        $I->acceptPopup();

        $I->seeInDatabase('user', array('id' => 1, 'firstname' => 'Rosa', 'lastname' => 'Parks'));
    }
}
