#!/bin/sh

#so to make life easier, first time this script is run check the ~/.bash_profile for an alias
LINE='alias twinkl-test="sh $PWD/_twinkl_ide/scripts/twinkl.sh"'
FILE=~/.bash_profile

if [ $SHELL = '/bin/zsh' ]; then
  FILE=~/.zshrc
fi

# check twinkl command exists
if ! ($SHELL -l -i -c "type twinkl-test") > /dev/null 2>&1; then
  echo ""
  echo "* We've just created an alias for this script";
  echo "* From now on you only need to run: twinkl-test"
  echo "* And all the commands will be available to you";
  echo ""
   # 1. append alias to .bash_profile
   # 2. reload terminal with new alias / kill old shell to prevent dupe commands
   echo "$LINE" | tee -a $FILE > /dev/null;exec $SHELL -l -i && kill $PPID
fi

#this is nothing more than a wrapper to call subsequent shell scripts
if [[ $# -eq 0 ]] ; then
    echo
    echo 'No arguments provided, please execute in the following format: ';
    echo
    echo 'twinkl [argument]';
    echo
    echo 'Available commands include:'
    echo
    echo '* twinkl-test start';
    echo '* twinkl-test status';
    echo '* twinkl-test stop';
    echo '* twinkl-test export (made changes to the database? Export and commit)';
    echo
    exit 1;
fi

scripts_path="$(pwd)/_twinkl_ide/scripts";
SCRIPT="$scripts_path/$1.sh";

if [ ! -f "$SCRIPT" ]; then
    echo "Sorry that file doesn't exist."
    exit 1;
fi

#first up is docker already running
if ! docker ps > /dev/null 2>&1 ; then
  echo
  echo "== Be sure docker is running before using these commands"
  echo
  while ! docker ps > /dev/null 2>&1 ; do sleep 2; done
fi

sh "$scripts_path/$1.sh"
