<?php

use Illuminate\Events\Dispatcher;
use Illuminate\Http\Request;
use Illuminate\Routing\Router;
use Twinkl\Core\Consts\HttpConsts;
use Twinkl\Core\Exception\ExceptionExt;
use Twinkl\Dashboard\Controller\DashboardController;
use Twinkl\Dashboard\Controller\DashboardUserController;

$request = Request::createFromGlobals();

try {
    $router = new Router(new Dispatcher());
    $router->resource('dashboard/users', DashboardUserController::class);
    
    $router->any('/', [DashboardController::class, 'index']);
    
    $router
        ->dispatch($request)
        ->send();
} catch (Exception $ex) {
    $exCode = $ex->getCode();
    throw new ExceptionExt(
        "Routing failed for: {$request->getMethod()} {$request->url()}.",
        $exCode < 1
            ? HttpConsts::CODE_SERVER_ERROR
            : $exCode,
        $ex->getMessage(),
        null,
        $ex
    );
}


