## Twinkl-test - Web Dev - Web Support (WS) tech exercise V1

Welcome to the WS tech exercise!

You have been invited as collaborator to this project. In order to clone the repository locally, you will need to generate a `Personal Access Token` (PAT) linked to your github account:

* [Github tutorial generate PAT](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token)
* [Generate your PAT here](https://github.com/settings/tokens)

This PAT can then be used to clone the repository in the following format:
```
git clone https://[personalAccessToken]@github.com/organisation/repository.git
```

This follows the HTTP authentication method:

```
https://[username]:[password]@example-site
```

However since the PAT token contains your authentication details, including username you can omit these details from the HTTP authentication request.

Failing that you can always set up SSH authentication and clone via SSH:

* [Setting up ssh access](https://docs.github.com/en/github/authenticating-to-github/connecting-to-github-with-ssh/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent)
* [Adding ssh public key to github account](https://docs.github.com/en/github/authenticating-to-github/connecting-to-github-with-ssh/adding-a-new-ssh-key-to-your-github-account)
---

## Use main instead of master

In keeping with the wider move adopted by github, the default branch of this repository is `main` not `master`. We have taken this decision for cultural sensitivity reasons.

Read more about this industry switch here:

[https://www.techrepublic.com/article/github-to-replace-master-with-main-starting-in-october-what-developers-need-to-know/](https://www.techrepublic.com/article/github-to-replace-master-with-main-starting-in-october-what-developers-need-to-know/)

We are not prescribing a branching methodology, we are more interested how you currently handle hotfix/ feature branches and migrate code from staging to production.

We would also like to see how you handle your ticket documentation:

1. From accepting new tickets via the [Projects board](../../projects/1) and progressing these ticket through their various states (Accepted | In progress | Ready | Review | Deployed)
1. To updating existing [Issues](../../issues) adding extra information, screenshots, error reports. Ensuring that the issue has all relevant information.
1. And providing testing notes, via the resulting [Pull requests](../../pulls)

### Automatic Pull Request Generation

Because we have made use of [github workflows](../../tree/main/.github/workflows) we are able to automate many things within the repository. When you create a new branch and make your first commit, Github will automatically create a new [Pull Request](../../pulls).

Pull requests are designed to help pair coding, by inviting colleagues to review your work.

---

## About the application

This is a small project, developed using MVC/ REST principles.

The Backend is PHP:
- It is primarily bespoke code.
- Includes [Laravel database & routing](https://laravel.com/docs/7.x/routing) libraries for routing and DB abstraction.
- Includes [League/Plates](https://platesphp.com/) library to provide view templates system.

The Frontend is JS ES6 / ES2015:
- Uses combination of [Webpack](https://webpack.js.org/guides/getting-started/) and [Babel](https://babeljs.io/docs/en/configuration) to transpile to native JS and CSS.
- Uses SCSS / SASS for stylesheets.

---

## Getting started

You have two options:

* Run the in-built IDE. This is probably your fastest route to editing the website. All you need to have installed is Docker desktop. Works on Windows and Mac boxes and can be started via

`docker-compose up -d` or `sh _twinkl_ide/scripts/twinkl.sh`

The website will be available at:

[http://localhost:8080](http://localhost:8080)
* Spin up/ integrate the Site files into your preferred IDE (XAMPP/ WAMP). Continue to read about integrating the project into these systems...

To get started you will require the following installed:

1. Local PHP environment (^ v7.3) - [XAMPP](https://www.apachefriends.org/download.html) from apache friends is one we used.
2. Local MYSQL server - [XAMPP](https://www.apachefriends.org/download.html) from apache friends can provide this.
3. Node (^ v11.15.*)
4. NPM (^ v6.7)
5. Composer (^ v1.9)

## Initialising app

### Database

SQL scripts for the DB structure used in this test, can be found: [Sites/backend/database](../../tree/main/Sites/backend/database). Please execute the scripts via your MYSQL server / IDE.

However, if you are using the inbuilt IDE the database is already available for you and accessible via:

```
db host: 127.0.0.1
db port: 3306 
db user: root
db password: root
```
Failing that phpmyadmin is available at [http://localhost:8084](http://localhost:8084).

### Code

1. Open Terminal / Command prompt / Bash UI
2. Navigate to "twinkl-test/Sites/backend", and execute `composer install` to install PHP dependencies.
3. Navigate to "twinkl-test/Sites/frontend", and execute `npm install` to install JS dependencies.
4. Execute `npm run build` to build the distributables into the "/public" folder.

---

## Exercises

[### 1. Application doesn't load](../../issues/1)

There is a bug when loading the application, please debug and resolve so the users appear on the main page.

[### 2. Missing users](../../issues/2)

Not all of the available users appear on the dashboard and there is a duplicate user. The DB data is currently correct, please investigate the code and amend the bug causing a limited amount of users and a duplicate to appear.

[### 3. Can't add users](../../issues/3)

There is a bug when clicking "Add User", please resolve to enable a widget to appear for creating a user.

[### 4. Can't update users](../../issues/4)

Currently the "Update" button for existing users is not operational. Please implement the JS & PHP required to update a user's details.

[### 5. Optimise database](../../issues/5)

Currently the SQL schema for the database & tables (see **./database/tables**) have not been optimised for queries. Please amend the schema so ensure optimum performance on the most common queries / operations. 
 